CREATE OR REPLACE FUNCTION sp_InsertTreeNode (VARCHAR, INTEGER, VARCHAR, VARCHAR, VARCHAR, INTEGER, VARCHAR, INTEGER)
RETURNS void AS $$
DECLARE
    pGuid ALIAS FOR $1;
    pType ALIAS FOR $2;
    pDisplayName ALIAS FOR $3;
    pParentGuid ALIAS FOR $4;
    pIconName ALIAS FOR $5;
    pProductType ALIAS FOR $6;
    pState ALIAS FOR $7;
    pDeviceType ALIAS FOR $8;
    -- pProductType INT = 0
    foundParent INTEGER;
    foundNode INTEGER;
    idxLeftCasFolder BIGINT;
    idxRightCasFolder BIGINT;
    idxLeftEntity BIGINT;
    idxRightEntity BIGINT;
    OLD_DisplayName VARCHAR(64);
    OLD_ParentGuid CHAR(36);
    OLD_IconName VARCHAR(128);

BEGIN

SELECT CASE
    WHEN EXISTS(SELECT *
          FROM "tb_tree_node" AS tn
          WHERE tn.guid = pParentGuid
            )
    THEN 1
    ELSE 0
END INTO foundParent;


IF foundParent = 1 AND pParentGuid <> pGuid THEN
    SELECT CASE
        WHEN EXISTS(SELECT *
              FROM "tb_tree_node"
              WHERE guid = pGuid)
        THEN 1
        ELSE 0
    END INTO foundNode;

    IF foundNode = 1 THEN
        SELECT OLD_DisplayName = display_name, OLD_ParentGuid = parent_guid -- , OLD_IconName = IconName
        FROM "tb_tree_node"
        WHERE guid = pGuid;

        UPDATE "tb_tree_node"
        SET display_name = pDisplayName -- , "IconName" = pIconName
        WHERE guid = pGuid
            AND (OLD_DisplayName <> pDisplayName
                 -- OR OLD_IconName <> pIconName
                 );
    ELSE
        INSERT INTO "tb_tree_node" (guid,
                                type_,
                                display_name,
                                parent_guid,
                                -- "IconName",
                                product_type,
                                state,
                                device_type)
        VALUES (pGuid,
                pType,
                pDisplayName,
                pParentGuid,
                -- pIconName,
                pProductType,
                pState,
                pDeviceType);
        INSERT INTO "tb_acl_object_identity" (object_class_id, object_id) VALUES (2,pGuid);
    END IF;
END IF;
END;

$$ LANGUAGE plpgsql;
